/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatBootstrap;
import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.VMLauncherUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;

public class Tomcat6Bootstrap
extends TomcatBootstrap {
    public String[] getClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(String.valueOf(this.getTomcatDir()) + File.separator + "bin" + File.separator + "bootstrap.jar");
        String toolsJarLocation = VMLauncherUtility.getVMInstall().getInstallLocation() + File.separator + "lib" + File.separator + "tools.jar";
        if (new File(toolsJarLocation).exists()) {
            classpath.add(toolsJarLocation);
        }
        return classpath.toArray(new String[0]);
    }

    public String getMainClass() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    public String getStartCommand() {
        return "start";
    }

    public String getStopCommand() {
        return "stop";
    }

    public String[] getPrgArgs(String command) {
        String[] prgArgs = TomcatLauncherPlugin.getDefault().getConfigMode().equals("serverFile") ? new String[]{"-config", "\"" + TomcatLauncherPlugin.getDefault().getConfigFile() + "\"", command} : new String[]{command};
        return prgArgs;
    }

    public String[] getVmArgs() {
        ArrayList<String> vmArgs = new ArrayList<String>();
        vmArgs.add("-Dcatalina.home=\"" + this.getTomcatDir() + "\"");
        String endorsedDir = String.valueOf(this.getTomcatDir()) + File.separator + "endorsed";
        vmArgs.add("-Djava.endorsed.dirs=\"" + endorsedDir + "\"");
        String catalinaBase = this.getTomcatBase();
        if (catalinaBase.length() == 0) {
            catalinaBase = this.getTomcatDir();
        }
        vmArgs.add("-Dcatalina.base=\"" + catalinaBase + "\"");
        vmArgs.add("-Djava.io.tmpdir=\"" + catalinaBase + File.separator + "temp\"");
        if (TomcatLauncherPlugin.getDefault().isSecurityManagerEnabled()) {
            vmArgs.add("-Djava.security.manager");
            String securityPolicyFile = String.valueOf(catalinaBase) + File.separator + "conf" + File.separator + "catalina.policy";
            vmArgs.add("-Djava.security.policy=\"" + securityPolicyFile + "\"");
        }
        return vmArgs.toArray(new String[0]);
    }

    public String getXMLTagAfterContextDefinition() {
        return "</Host>";
    }

    public IPath getJasperJarPath() {
        return new Path("lib").append("jasper.jar");
    }

    public IPath getServletJarPath() {
        return new Path("lib").append("servlet-api.jar");
    }

    public IPath getJSPJarPath() {
        return new Path("lib").append("jsp-api.jar");
    }

    public IPath getElJarPath() {
        return new Path("lib").append("el-api.jar");
    }

    public IPath getAnnotationsJarPath() {
        return new Path("lib").append("annotations-api.jar");
    }

    public Collection getTomcatJars() {
        IPath tomcatHomePath = TomcatLauncherPlugin.getDefault().getTomcatIPath();
        ArrayList jars = (ArrayList)super.getTomcatJars();
        jars.add(JavaCore.newVariableEntry((IPath)tomcatHomePath.append(this.getElJarPath()), null, null));
        jars.add(JavaCore.newVariableEntry((IPath)tomcatHomePath.append(this.getAnnotationsJarPath()), null, null));
        return jars;
    }

    public String getLabel() {
        return "Tomcat 6.x";
    }

    public String getContextWorkDir(String workFolder) {
        StringBuffer workDir = new StringBuffer("workDir=");
        workDir.append('\"');
        workDir.append(workFolder);
        workDir.append('\"');
        return workDir.toString();
    }
}

