/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.TomcatProject;
import com.sysdeo.eclipse.tomcat.TomcatProjectPropertyPage;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TomcatProjectWARPropertyPage
implements TomcatPluginResources {
    private Button exportSourceCheck;
    private Text warLocationText;
    private Text rootDirText;
    private TomcatProjectPropertyPage page;
    private static final int TEXT_FIELD_WIDTH = 200;

    public TomcatProjectWARPropertyPage(TomcatProjectPropertyPage page) {
        this.page = page;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createWarLocationGroup(composite);
        return composite;
    }

    public void createWarLocationGroup(Composite parent) {
        Composite warLocationGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        warLocationGroup.setLayout((Layout)layout);
        warLocationGroup.setLayoutData((Object)new GridData(768));
        Label warLocationLabel = new Label(warLocationGroup, 0);
        warLocationLabel.setText(WIZARD_PROJECT_WARLOCATION_LABEL);
        warLocationLabel.setEnabled(true);
        this.warLocationText = new Text(warLocationGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.warLocationText.setLayoutData((Object)data);
        this.warLocationText.setText(this.getWarLocation());
        this.warLocationText.setEnabled(true);
        Button browseButton = new Button(warLocationGroup, 8);
        browseButton.setText(BROWSE_BUTTON_LABEL);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String newValue = TomcatProjectWARPropertyPage.this.warFieldChange();
                if (newValue != null) {
                    TomcatProjectWARPropertyPage.this.warLocationText.setText(newValue);
                }
            }
        });
        browseButton.setEnabled(true);
        this.exportSourceCheck = new Button(warLocationGroup, 16416);
        this.exportSourceCheck.setText(WIZARD_PROJECT_EXPORTSOURCE_LABEL);
        data = new GridData();
        data.horizontalSpan = 3;
        this.exportSourceCheck.setLayoutData((Object)data);
        this.exportSourceCheck.setEnabled(true);
        this.exportSourceCheck.setSelection(this.getExportSource());
    }

    protected String getWarLocation() {
        String result = "";
        try {
            TomcatProject prj = this.page.getTomcatProject();
            if (prj != null) {
                result = prj.getWarLocation();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    protected boolean getExportSource() {
        boolean result = false;
        try {
            TomcatProject prj = this.page.getTomcatProject();
            if (prj != null) {
                result = prj.getExportSource();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return result;
    }

    public boolean performOk() {
        try {
            TomcatProject prj = this.page.getTomcatProject();
            prj.setWarLocation(this.warLocationText.getText());
            prj.setExportSource(this.exportSourceCheck.getSelection());
            prj.saveProperties();
        }
        catch (Exception ex) {
            TomcatLauncherPlugin.log(ex.getMessage());
        }
        return true;
    }

    protected String warFieldChange() {
        File d;
        File f = new File(this.warLocationText.getText());
        if (!f.exists()) {
            f = null;
        }
        if ((d = this.getFile(f)) == null) {
            return null;
        }
        return d.getAbsolutePath();
    }

    private File getFile(File startingDirectory) {
        String file;
        FileDialog dialog = new FileDialog(this.page.getShell(), 4096);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }
}

