/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import java.util.ArrayList;
import java.util.List;

public class WebClassPathEntries {
    public static final String TAG_NAME = "webClassPathEntries";
    private static final String ENTRY_TAG_NAME = "webClassPathEntry";
    private List entries;

    public WebClassPathEntries() {
        this.entries = new ArrayList();
    }

    public WebClassPathEntries(List values) {
        this.entries = values;
    }

    public int size() {
        return this.entries.size();
    }

    public String getWebClassPathEntry(int index) {
        if (index >= this.entries.size()) {
            return null;
        }
        String entry = (String)this.entries.get(index);
        return entry;
    }

    public void addWebClassPathEntry(String value) {
        if (this.entries.contains(value)) {
            return;
        }
        this.entries.add(value);
    }

    public List getList() {
        return this.entries;
    }

    public String xmlMarshal() {
        return this.xmlMarshal(0);
    }

    public String xmlMarshal(int spacesToIntend) {
        String spaces = "";
        int i = 0;
        while (i < spacesToIntend) {
            spaces = String.valueOf(spaces) + " ";
            ++i;
        }
        String xml = String.valueOf(spaces) + WebClassPathEntries.startTag() + "\n";
        for (String entry : this.entries) {
            xml = String.valueOf(xml) + spaces + spaces + WebClassPathEntries.startEntryTag() + entry + WebClassPathEntries.endEntryTag() + "\n";
        }
        xml = String.valueOf(xml) + spaces + WebClassPathEntries.endTag() + "\n";
        return xml;
    }

    public static WebClassPathEntries xmlUnmarshal(String xmlString) {
        if (xmlString == null || xmlString.trim().length() == 0) {
            return null;
        }
        int start = xmlString.indexOf(WebClassPathEntries.startTag());
        int end = xmlString.indexOf(WebClassPathEntries.endTag());
        if (start < 0 || end <= start) {
            return null;
        }
        String value = xmlString.substring(start + WebClassPathEntries.startTag().length(), end);
        value = value.trim();
        WebClassPathEntries webEntries = new WebClassPathEntries();
        while (value != null && value.length() > 0) {
            start = value.indexOf(WebClassPathEntries.startEntryTag());
            end = value.indexOf(WebClassPathEntries.endEntryTag());
            if (start >= 0 || end > start) {
                String entryValue = value.substring(start + WebClassPathEntries.startEntryTag().length(), end);
                if (entryValue.trim().length() > 0) {
                    webEntries.addWebClassPathEntry(entryValue);
                }
                value = value.substring(end + WebClassPathEntries.endEntryTag().length());
                continue;
            }
            value = null;
        }
        return webEntries;
    }

    private static String startTag() {
        return "<webClassPathEntries>";
    }

    private static String endTag() {
        return "</webClassPathEntries>";
    }

    private static String startEntryTag() {
        return "<webClassPathEntry>";
    }

    private static String endEntryTag() {
        return "</webClassPathEntry>";
    }

    public static void main(String[] arguments) {
        String xml = "";
        WebClassPathEntries entries = WebClassPathEntries.xmlUnmarshal(xml);
        if (entries != null) {
            System.err.println("invalid xml must result in null object !");
            System.exit(1);
        }
        if ((entries = WebClassPathEntries.xmlUnmarshal(xml = "<webClassPathEntries></webClassPathEntries>")) == null) {
            System.err.println("valid xml must result in an object !");
            System.exit(1);
        }
        if (entries.size() != 0) {
            System.err.println("expected size 0 but was " + entries.size());
            System.exit(1);
        }
        if ((entries = WebClassPathEntries.xmlUnmarshal(xml = "<root><webClassPathEntries>\n</webClassPathEntries>\n</root>")) == null) {
            System.err.println("valid xml must result in an object !");
            System.exit(1);
        }
        if (entries.size() != 0) {
            System.err.println("expected size 0 but was " + entries.size());
            System.exit(1);
        }
        if ((entries = WebClassPathEntries.xmlUnmarshal(xml = "<webClassPathEntries><webClassPathEntry>abc</webClassPathEntry></webClassPathEntries>")) == null) {
            System.err.println("valid xml must result in an object !");
            System.exit(1);
        }
        if (entries.size() != 1) {
            System.err.println("expected size 1 but was " + entries.size());
            System.exit(1);
        }
        if (!entries.getWebClassPathEntry(0).equals("abc")) {
            System.err.println("expected 'abc' but was '" + entries.getWebClassPathEntry(0) + "'");
            System.exit(1);
        }
        if ((entries = WebClassPathEntries.xmlUnmarshal(xml = "<webClassPathEntries>\n<webClassPathEntry>abc</webClassPathEntry>\n<webClassPathEntry>def</webClassPathEntry>\n<webClassPathEntry>123</webClassPathEntry>\nxxxxx</webClassPathEntries>\n")) == null) {
            System.err.println("valid xml must result in an object !");
            System.exit(1);
        }
        if (entries.size() != 3) {
            System.err.println("expected size 1 but was " + entries.size());
            System.exit(1);
        }
        if (!entries.getWebClassPathEntry(0).equals("abc")) {
            System.err.println("expected 'abc' but was '" + entries.getWebClassPathEntry(0) + "'");
            System.exit(1);
        }
        if (!entries.getWebClassPathEntry(1).equals("def")) {
            System.err.println("expected 'def' but was '" + entries.getWebClassPathEntry(1) + "'");
            System.exit(1);
        }
        if (!entries.getWebClassPathEntry(2).equals("123")) {
            System.err.println("expected '123' but was '" + entries.getWebClassPathEntry(2) + "'");
            System.exit(1);
        }
        xml = "<webClassPathEntries>\n<webClassPathEntry>abc</webClassPathEntry>\n<webClassPathEntry>def</webClassPathEntry>\n<webClassPathEntry>123</webClassPathEntry>\n</webClassPathEntries>\n";
        String gen = entries.xmlMarshal();
        if (!gen.equals(xml)) {
            System.err.println("generated xml is incorrect:\n!" + gen + "!");
            System.err.println("expected xml is :\n!" + xml + "!");
            System.exit(1);
        }
        System.out.println("All okay !");
    }
}

