/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private static final int BUFFER = 2048;
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private Vector filesets = new Vector();
    protected Hashtable addedDirs = new Hashtable();
    private File outputFile = null;
    private File directory = null;
    private FileOutputStream fos = null;
    private ZipOutputStream zos = null;
    private String currentDirName;

    public Zipper(File outputFile, File directory) throws IOException {
        this.outputFile = outputFile;
        this.directory = directory;
        this.currentDirName = directory.getAbsolutePath();
    }

    public void zip() throws IOException {
        this.fos = new FileOutputStream(this.outputFile);
        this.zos = new ZipOutputStream(this.fos);
        this.zipDir(this.directory);
        this.zos.flush();
        this.zos.close();
        this.fos.close();
    }

    private void zipDir(File dir) throws IOException {
        if (!dir.getPath().equals(this.currentDirName)) {
            String entryName = dir.getPath().substring(this.currentDirName.length() + 1);
            entryName = entryName.replace('\\', '/');
            ZipEntry ze = new ZipEntry(String.valueOf(entryName) + "/");
            if (dir != null && dir.exists()) {
                ze.setTime(dir.lastModified());
            } else {
                ze.setTime(System.currentTimeMillis());
            }
            ze.setSize(0L);
            ze.setMethod(0);
            ze.setCrc(EMPTY_CRC);
            this.zos.putNextEntry(ze);
        }
        if (dir.exists() && dir.isDirectory()) {
            File[] fileList = dir.listFiles();
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].isDirectory() && this.acceptDir(fileList[i])) {
                    this.zipDir(fileList[i]);
                }
                if (fileList[i].isFile() && this.acceptFile(fileList[i])) {
                    this.zipFile(fileList[i]);
                }
                ++i;
            }
        }
    }

    private void zipFile(File file) throws IOException {
        if (!file.equals(this.outputFile)) {
            int byteCount;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 2048);
            String entryName = file.getPath().substring(this.currentDirName.length() + 1);
            entryName = entryName.replace('\\', '/');
            ZipEntry fileEntry = new ZipEntry(entryName);
            this.zos.putNextEntry(fileEntry);
            byte[] data = new byte[2048];
            while ((byteCount = bis.read(data, 0, 2048)) != -1) {
                this.zos.write(data, 0, byteCount);
            }
            bis.close();
        }
    }

    protected boolean acceptDir(File dir) {
        return true;
    }

    protected boolean acceptFile(File file) {
        return true;
    }
}

